    <div class="card mb-5">
        <div class="card-header">
            <b>EMISSÃO DE BOLETO DE IPTU</b>
        </div>
        <div class="card-body mb-5">
            <div class="col-sm-12 col-md-4 offset-md-4">
                <form wire:submit.prevent="find">
                    
                    <div class="form-group">
                        <label for="inscricao">Inscrição do Imóvel</label>
                        <input wire:model.lazy="inscricao" class="form-control mr-sm-2 m-auto" aria-label="Pesquisar"
                            id="inscricao" type="search" placeholder="Digite a inscrição do imóvel..." />
                    </div>
                    
                    <button type="button" wire:click="find" class="btn btn-primary btn-block">PESQUISAR</button>
                </form>
            </div>

            <div class="m-3">
                <div wire:loading class='col-sm-12 col-md-6 offset-md-3'>
                    <div class="alert alert-info text-center" role="alert">
                        CARREGANDO...
                    </div>
                </div>
            </div>

            
            <?php if(session()->has('message')): ?>
            <div class='col-sm-12 col-md-6 offset-md-3'>
                <div class="alert alert-danger text-center" role="alert">
                    <span> <?php echo e(session('message')); ?> </span>
                </div>
            </div>
            <?php endif; ?>
        </div>

        <?php if(!empty($imovel)): ?>

        <div class="card mt-1">
            <div class="card-header">
                <b>Dados do Imóvel</b>
            </div>
            <div class="card-body">
                <p><b>Inscrição:</b> <?php echo e($imovel->inscricao ?? '--'); ?></p>
                <p><b>Cidade:</b> <?php echo e($imovel->cidade ?? '--'); ?></p>
                <p><b>UF:</b> <?php echo e($imovel->uf ?? '--'); ?></p>
                <p><b>Bairro:</b> <?php echo e($imovel->bairro ?? '--'); ?></p>
                <p><b>Endereço:</b> <?php echo e($imovel->endereco ?? '--'); ?></p>
            </div>
        </div>

        
            <div class="card mt-1">
                <div class="card-header">
                    <b>Débitos</b>
                </div>
                <div class="card-body">
                    <table class="table">
                        <thead>
                          <tr>
                            <th scope="col">Descrição</th>
                            <th scope="col">Vencimento</th>
                            <th scope="col">Valor</th>
                            <th scope="col">Boleto</th>
                          </tr>
                        </thead>
                        <tbody>
                            <?php if(!empty($financeiros)): ?>
                                <?php $__currentLoopData = $financeiros; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $financeiro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($financeiro->descricao); ?></td>
                                        <td><?php echo e(date('d/m/yy', strtotime($financeiro->vencimento))); ?></td>
                                        <td><?php echo e('R$ '.number_format($financeiro->valor, 2, ',', '.')); ?></td>
                                        <td><a href="<?php echo e(route('boleto', ['id' => $financeiro->idfinanceiro])); ?>" target=“_blank”><u>Imprimir</u></a></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>    
                        </tbody>
                      </table>                    
                </div>
            </div>

        
    <?php endif; ?>

    </div>

    <script>
        $("#iptu").addClass("active");

    </script>
<?php /**PATH C:\xampp\htdocs\portal_contribuinte\resources\views/livewire/iptu/iptu.blade.php ENDPATH**/ ?>