

<div class="mt-3">

    <div class="col-12 mt-3 mb-3 text-center" style="color: #536c79">
        <div class="mt-2">
            <h2><b>CONSULTA NOTAS</b></h2>
        </div>
    </div>

    <div class="card">
        <div class="card-header font-semibold text-center">
            <?php echo e(__('FILTROS')); ?>

        </div>

        <?php if(session()->has('message')): ?>
            <div class="alert alert-danger">
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <i class="material-icons">close</i>
                </button>
                <span>
                <?php echo e(session('message')); ?></span>
            </div>
        <?php endif; ?>

        <br>
        <div>
            <nav class="navbar navbar-light bg-light">
                

                <div class="col-sm-12 col-md-4">
                    <label>Tomador</label>
                    <input wire:model="tomador"
                           class="form-control" aria-label="Pesquisar"
                           id="search" type="search" placeholder=""/>
                </div>

                <div class="col-sm-12 col-md-4">
                    <label>A partir de:</label>
                    <input wire:model="inicio" type="date" class="form-control" id="inicio" placeholder="">
                </div>

                <div class="col-sm-12 col-md-4">
                    <label>Até:</label>
                    <input wire:model="fim" type="date" class="form-control" id="dim" placeholder="">
                </div>

                <div class="col-sm-12 col-md-4 offset-md-4 mt-4">
                    <button wire:click="pesquisar" type="button" class=" btn-block btn-primary">Pesquisar</button>
                    <button onclick="imprimir()" type="button" class=" btn-block btn-success">Imprimir</button>
                </div>
                
            </nav>
            
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead class="text-dark">
                            <tr>
                                <th class="text-center">RESULTADO</th>
                            </tr>
                        </thead>
                        <tbody wire:loading.remove>
                            <?php if(session()->has('message')): ?>
                            <div class="alert alert-danger">
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <i class="material-icons">close</i>
                                </button>
                                <span>
                                    <?php echo e(session('message')); ?></span>
                                </div>
                                <?php endif; ?>                            
                            </tbody>
                    </table>
                </div>
            </div>
                
        </div>
    </div>

    <table class="table" style="font-size: 10px">
        <thead class="thead-dark">
        <tr>
            <th scope="col">Número</th>
            <th scope="col">Data</th>
            <th scope="col">Situação</th>
            <th scope="col">Tomador</th>
            <th scope="col">Tomador CNPJ/CPF</th>
            <th scope="col">Prestador</th>
            <th scope="col">Razão Social</th>
            <th scope="col">Prestador CNPJ/CPF</th>
            <th scope="col">Discriminação</th>
            
            <th scope="col">Valor Total</th>
            <th scope="col">Valor Acréscimos</th>
            <th scope="col">Base Cálculo</th>
            <th scope="col">Iss Retido</th>
            <th scope="col">Valor Inss</th>
            <th scope="col">Valor Irrf</th>
            <th scope="col">Aliq Irrf</th>
            <th scope="col">Valor Deduções</th>
            <th scope="col">Dedução Irrf</th>
            <th scope="col">Total Retenção</th>
            <th scope="col">Aliq Percentual</th>
            
        </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $searchResult; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                
                
                    <tr>
                        <th scope="row"><?php echo e($result->numero); ?></th>
                        <td><?php echo e(date("d/m/Y", strtotime($result->datahoraemissao))); ?></td>
                        <td><?php echo e($result->estado); ?></td>
                        <td><?php echo e($result->tomador_nome); ?></td>
                        <td><?php echo e($result->tomador_cnpjcpf); ?></td>
                        <td><?php echo e($result->nome); ?></td>
                        <td><?php echo e($result->razaosocial); ?></td>
                        <td><?php echo e($result->cnpj); ?></td>
                        <td><?php echo e($result->discriminacao); ?></td>
                        
                        <td><?php echo e(number_format($result->valortotal,2,",",".")); ?></td>
                        <td><?php echo e(number_format($result->valoracrescimos,2,",",".")); ?></td>
                        <td><?php echo e(number_format($result->basecalculo,2,",",".")); ?></td>
                        <td><?php echo e(number_format($result->issretido,2,",",".")); ?></td>
                        <td><?php echo e(number_format($result->valorinss,2,",",".")); ?></td>
                        <td><?php echo e(number_format($result->valorirrf,2,",",".")); ?></td>
                        <td><?php echo e(number_format($result->aliqirrf,2,",",".")); ?></td>
                        <td><?php echo e(number_format($result->valordeducoes,2,",",".")); ?></td>
                        <td><?php echo e(number_format($result->deducao_irrf,2,",",".")); ?></td>
                        <td><?php echo e(number_format($result->total_retencao,2,",",".")); ?></td>
                        <td><?php echo e(number_format($result->aliq_percentual,2,",",".")); ?></td>
                        
                    </tr>

            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr class="px-4 py-4">
                    <td class="text-gray-300">
                        Nenhum resultado encontrado
                    </td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>

    <div class="row ml-3">
        Valor Total: <?php echo e(number_format($valortotal,2,",",".")); ?>

    </div>

    <div class="row justify-content-center">
        <div wire:loading class='justify-content-center'>
            CARREGANDO...
        </div>
    </div>

</div>

<script>
    function imprimir(){
        window.print();
    }
</script><?php /**PATH C:\xampp\htdocs\consulta_notas\resources\views/livewire/instituicao/selecao.blade.php ENDPATH**/ ?>