<div class="card mb-5">
    <div class="card-header">
        <b>EMISSÃO DE CERTIDÃO NEGATIVA</b>
    </div>
    <div class="card-body mb-5">
        <div class="col-sm-12 col-md-4 offset-md-4">
            <form wire:submit.prevent="find">
                <div class="form-group">
                    <label for="cnpj_cpf">CPF / CNPJ</label>
                    <input wire:model.lazy="cnpj_cpf" class="form-control mr-sm-2 m-auto" aria-label="Pesquisar"
                        id="cnpj_cpf" type="search" placeholder="Digite o CPF/CNPJ..." />
                </div>
                <button type="button" wire:click="find" class="btn btn-primary btn-block">PESQUISAR</button>
            </form>
        </div>

        <div class="m-3">
            <div wire:loading class='col-sm-12 col-md-6 offset-md-3'>
                <div class="alert alert-info text-center" role="alert">
                    CARREGANDO...
                </div>
            </div>
        </div>

        
        <?php if(session()->has('message')): ?>
        <div class='col-sm-12 col-md-6 offset-md-3'>
            <div class="alert alert-danger text-center" role="alert">
                <span> <?php echo e(session('message')); ?> </span>
            </div>
        </div>
        <?php endif; ?>
    </div>

    <?php if(!empty($fornecedor)): ?>

    <div class="card mt-1">
        <div class="card-header">
            <b>Dados do Fornecedor</b>
        </div>
        <div class="card-body">
            <p><b>Nome:</b> <?php echo e($fornecedor->nome ?? '--'); ?></p>
            <p><b>CPF/CNPJ:</b> <?php echo e($fornecedor->cnpj_cpf ?? '--'); ?></p>
            <p><b>Cidade:</b> <?php echo e($fornecedor->cidade ?? '--'); ?></p>
            <p><b>UF:</b> <?php echo e($fornecedor->uf ?? '--'); ?></p>
            

            <a class="btn btn-success mt-3" href="<?php echo e(route('certidao-pdf', ['cnpj_cpf' => $fornecedor->cnpj_cpf])); ?>" target=“_blank”>EMITIR CERTIDÃO NEGATIVA</a>
        </div>
    </div>

    <?php endif; ?>

</div>

<script>
    $("#certidao").addClass("active");

</script>
<?php /**PATH C:\xampp\htdocs\portal_contribuinte\resources\views/livewire/certidao/certidao.blade.php ENDPATH**/ ?>