<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="description" content="Portal do Contribuinte" />
    <meta name="author" content="" />

    <title><?php echo e($nome); ?> | PORTAL DO CONTRIBUINTE</title>

    <link rel="icon" href="./public/images/brasoes/<?php echo e($cnpj); ?>.png">

    <!-- Fonts -->

    <!-- Styles -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css"
        integrity="sha384-Gn5384xqQ1aoWXA+058RXPxPg6fy4IWvTNh0E263XmFcJlSAwiGgFAW/dAiS6JXm" crossorigin="anonymous">
    <link rel="stylesheet" href="<?php echo e(asset('public/css/app.css')); ?>" id="style-resource-4">
    <script src="https://use.fontawesome.com/4028198248.js"></script>
    <script src="https://cdn.jsdelivr.net/gh/alpinejs/alpine@v2.6.0/dist/alpine.js" defer></script>
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"
        integrity="sha256-9/aliU8dGd2tb6OSsuzixeV4y/faTqgFtohetphbbj0=" crossorigin="anonymous"></script>
    <?php echo \Livewire\Livewire::styles(); ?>

</head>

<body>
    <!-- SKINS: skin-black -->

    <div class="container">
        <!-- BEGIN COMPONENT: SIDEBAR -->
        <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('header', [])->html();
} elseif ($_instance->childHasBeenRendered('YhG0twy')) {
    $componentId = $_instance->getRenderedChildComponentId('YhG0twy');
    $componentTag = $_instance->getRenderedChildComponentTagName('YhG0twy');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('YhG0twy');
} else {
    $response = \Livewire\Livewire::mount('header', []);
    $html = $response->html();
    $_instance->logRenderedChild('YhG0twy', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
            <?php echo $__env->yieldContent('content'); ?>
    </div>


    <link rel="stylesheet" href="<?php echo e(asset('public/js/jvectormap/jquery-jvectormap-1.2.2.css')); ?>" id="style-resource-1" />

    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.9/umd/popper.min.js"
        integrity="sha384-ApNbgh9B+Y1QKtv3Rn7W3mgPxhU9K/ScQsAP7hUibX39j7fakFPskvXusvfa0b4Q" crossorigin="anonymous">
    </script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js"
        integrity="sha384-JZR6Spejh4U02d8jOt6vLEHfe/JQGiRRSQQxSfFWpi1MquVdAyjUar5+76PVCmYl" crossorigin="anonymous">
    </script>

    <?php echo \Livewire\Livewire::scripts(); ?>

</body>
<footer>
    <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('footer', [])->html();
} elseif ($_instance->childHasBeenRendered('lbowe7S')) {
    $componentId = $_instance->getRenderedChildComponentId('lbowe7S');
    $componentTag = $_instance->getRenderedChildComponentTagName('lbowe7S');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('lbowe7S');
} else {
    $response = \Livewire\Livewire::mount('footer', []);
    $html = $response->html();
    $_instance->logRenderedChild('lbowe7S', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
</footer>

</html>
<?php /**PATH C:\xampp\htdocs\portal_contribuinte\resources\views/layouts/template.blade.php ENDPATH**/ ?>