<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\ImovelController;
use \App\Http\Controllers\Api\FornecedorController;
use App\Http\Controllers\Api\FinanceiroController;
use App\Http\Controllers\Api\NfseController;
use App\Http\Controllers\Api\ItbiController;
use \App\Http\Controllers\Api\AlvaraFuncionamentoController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

//Route::middleware('auth.basic.once')->group( function () {
//    Route::apiResource('imoveis', ImovelController::class);
//});

Route::apiResource('imoveis', ImovelController::class);
Route::apiResource('fornecedores', FornecedorController::class);
Route::apiResource('financeiros', FinanceiroController::class);
Route::apiResource('nfse', NfseController::class);
Route::apiResource('alvara', AlvaraFuncionamentoController::class);
Route::apiResource('itbi', ItbiController::class);
