<div class="card mb-5">
    <div class="card-header">
        <b>VALIDAÇÃO CERTIDÃO NEGATIVA</b>
    </div>
    <div class="card-body mb-5">
        <div class="col-sm-12 col-md-4 offset-md-4">
            <form wire:submit.prevent wire:keydown.enter="find">
                <div class="form-group">
                    <label for="inscricao">Código de Autenticação</label>
                    <input wire:model.lazy="pesquisa" class="form-control mr-sm-2 m-auto" aria-label="Pesquisar"
                           id="pesquisa" type="search" placeholder="Digite o código de autenticação..."/>
                </div>
                {{-- <a wire:click="find" class="btn btn-primary">PESQUISAR</a> --}}
                <button type="button" wire:click="find" class="btn btn-primary btn-block">PESQUISAR</button>
            </form>
        </div>

        <div class="m-3">
            <div wire:loading class='col-sm-12 col-md-6 offset-md-3'>
                <div class="alert alert-info text-center" role="alert">
                    CARREGANDO...
                </div>
            </div>
        </div>

{{--        MENSAGEM CASO O IMÓVEL NÃO SEJA ENCONTRADO--}}
        @if (session()->has('message'))
            <div class='col-sm-12 col-md-6 offset-md-3'>
                <div class="alert alert-danger text-center" role="alert">
                    <span> {{ session('message') }} </span>
                </div>
            </div>
        @endif
    </div>

    @if(!empty($certidaoNegativa))
        <div wire:loading.remove class="card mt-1">
            <div class="card-header">
                <b>Confirmação de Autenticidade de Certidão</b>
            </div>
            <div class="card-body">
                <p><b>Nome do Contribuinte:</b> {{ $certidaoNegativa->nome_contribuinte ?? '--' }}</p>
                <p><b>CNPJ/CPF:</b> {{ $certidaoNegativa->cnpj_cpf ?? '--' }}</p>
                <p><b>Código de Controle:</b> {{ $certidaoNegativa->codigo_controle ?? '--' }}</p>
                <p><b>Data de Emissão:</b> {{ date_format($certidaoNegativa->created_at, 'd/m/Y') ?? '--' }}</p>
                {{-- <a class="btn btn-primary btn-link mt-3" href="{{ route('boleto', ['id' => 1])}}" target=“_blank”>Boleto</a> --}}
            </div>
        </div>
    @endif

</div>

<script>
    $("#certidao").addClass("active");
</script>

