<div class="card mb-5">
    <div class="card-header">
        <b>VALIDAR NFS-e</b>
    </div>
    <div class="card-body mb-5">
        <div class="col-sm-12 col-md-4 offset-md-4">
            <form wire:submit.prevent="find">
                <div class="form-group">
                    <label for="inscricao">Nº da NFS-e</label>
                    <input wire:model.lazy="numero_nsfe"
                           wire.keydown.enter="submit"
                           class="form-control mr-sm-2 m-auto" aria-label="Pesquisar"
                           id="numero_nsfe" type="search" placeholder="Digite o número da NFS-e..."/>
                    @error('numero_nsfe') <p><span class="text-danger"> {{ $message }} </span></p> @enderror
                </div>

                <div class="form-group">
                    <label for="codigo_verificacao">Código da Verificação da NFS-e</label>
                    <input wire:model.lazy="codigo_verificacao"
                           wire.keydown.enter="submit"
                           class="form-control mr-sm-2 m-auto" aria-label="Pesquisar"
                           id="codigo_verificacao" type="search" placeholder="Digite o Código da Verificação..."/>
                    @error('codigo_verificacao') <p><span class="text-danger"> {{ $message }} </span></p> @enderror
                </div>

                <button type="button" wire:click="find" class="btn btn-primary btn-block">PESQUISAR</button>
            </form>
        </div>

        <div class="m-3">
            <div wire:loading class='col-sm-12 col-md-6 offset-md-3'>
                <div class="alert alert-info text-center" role="alert">
                    CARREGANDO...
                </div>
            </div>
        </div>
    </div>

    @if(!empty($nfse))
    <div class="card">
        <div class="card-header font-weight-bold" style="color:#4cd137">
            <i class="fa fa-check-circle" ></i>
            <h5 style="display: inline-block;">NOTA FISCAL VERIFICADA</h5>
        </div>
        <div class="card-body">
            <div class="justify">
                <p><b>DADOS DA NOTA FISCAL</b></p>
                <br>
                <p><span class="font-weight-bold">Número: </span> {{ $nfse->na_numero }} </p>
                <p><span class="font-weight-bold">Data: </span> {{ $nfse->na_datanfse }} </p>
                <p><span class="font-weight-bold">CNPJ/CPF Prestador: </span> {{ $nfse->na_prestador }} </p>
                <p><span class="font-weight-bold">Nome Prestador: </span> {{ $nfse->na_nomeprestador }} </p>
                <p><span class="font-weight-bold">Valor: </span> {{ number_format($nfse->na_valor,2,",",".") }} </p>
                <p><span class="font-weight-bold">Situação: </span> {{ $nfse->na_situacao }} </p>
                <p><span class="font-weight-bold">Código de Verificação: </span> {{ $nfse->na_Validacao }} </p>
            </div>
        </div>
    </div>
    @else
        {{-- MENSAGEM CASO O REGISTRO NÃO SEJA ENCONTRADO --}}
        @if (session()->has('message'))
            <div class='col-sm-12 col-md-6 offset-md-3 mt-3'>
                <div class="alert alert-danger text-center" role="alert">
                    <i class="fa fa-times-circle" ></i>
                    <h5 style="display: inline-block;">NOTA FISCAL INVÁLIDA</h5>
                </div>
            </div>
        @endif
    @endif

</div>

<script>
    $("#nota-fiscal").addClass("active");
</script>
