<div class="card mb-5">
    <div class="card-header">
        <b>EMISSÃO DA GUIA DE TRANSMISSÃO DO ITBI</b>
    </div>
    <div class="card-body mb-5">
        <div class="col-sm-12 col-md-4 offset-md-4">
            <form wire:submit.prevent="find">
                <div class="form-group">
                    <label for="inscricao">Número da Guia</label>
                    <input wire:model.lazy="numero_guia" class="form-control mr-sm-2 m-auto" aria-label="Pesquisar"
                           id="numero_guia" type="search" placeholder="Digite o número da guia..."/>
                    @error('numero_guia') <p><span class="text-danger"> {{ $message }} </span></p> @enderror
                </div>

                <div class="form-group">
                    <label for="inscricao">Inscrição do Imóvel</label>
                    <input wire:model.lazy="inscricao" class="form-control mr-sm-2 m-auto" aria-label="Pesquisar"
                           id="inscricao" type="search" placeholder="Digite o número da inscrição..."/>
                    @error('inscricao') <p><span class="text-danger"> {{ $message }} </span></p> @enderror
                </div>

                <div class="form-group">
                    <label for="adquirente">CPF/CNPJ do Adquirente</label>
                    <input wire:model.lazy="adquirente"
                           class="form-control mr-sm-2 m-auto" aria-label="Pesquisar"
                           id="adquirente" type="search" placeholder="Digite o CPF/CNPJ do Adquirente..."/>
                    @error('adquirente') <p><span class="text-danger"> {{ $message }} </span></p> @enderror
                </div>

                <div class="form-group">
                    <label for="transmitente">CPF/CNPJ do Transmitente</label>
                    <input wire:model.lazy="transmitente"
                           class="form-control mr-sm-2 m-auto" aria-label="Pesquisar"
                           id="transmitente" type="search" placeholder="Digite o CPF/CNPJ do Transmitente..."/>
                    @error('transmitente') <p><span class="text-danger"> {{ $message }} </span></p> @enderror
                </div>

                <button type="button" wire:click="find" class="btn btn-primary btn-block">PESQUISAR</button>
            </form>
        </div>

        <div class="m-3">
            <div wire:loading class='col-sm-12 col-md-6 offset-md-3'>
                <div class="alert alert-info text-center" role="alert">
                    CARREGANDO...
                </div>
            </div>
        </div>
    </div>

    @if(!empty($adquirente_obj) && !empty($transmitente_obj) && !empty($inscricao_obj))

        <div class="card">
            <div class="card-header font-weight-bold">
                TRANSFERÊNCIA DE TITULARIDADE DE IMÓVEL
                <h5>No Controle : 000052020</h5>
            </div>
            <div class="card-body">
                <div class="justify">
                    <p class="card-text">Eu,
                        <span class="font-weight-bold">{{ $adquirente_obj->nome }}</span>, CPF/CNPJ No <span
                            class="font-weight-bold">{{ $adquirente_obj->cnpj_cpf }}</span>,
                        residente em <span class="font-weight-bold">{{ $adquirente_obj->endereco }}, {{ $adquirente_obj->numero ?? 'SN' }}</span>,
                        Bairro <span class="font-weight-bold">{{ $adquirente_obj->bairro }}</span>, venho respeitosamente solicitar aos órgãos
                        competentes a transferência de Titularidade de Imóvel, conforme documentos anexo, do
                        imóvel de inscrição imobiliária No <span
                            class="font-weight-bold">{{ $inscricao_obj->inscricao }}</span> localizado em <span
                            class="font-weight-bold">{{ $inscricao_obj->endereco }}, {{ $inscricao_obj->numero ?? 'SN' }}</span>,
                        Bairro <span class="font-weight-bold">{{ $inscricao_obj->bairro }}</span> para
                        o(a) senhor(a)
                        <span class="font-weight-bold">{{ $transmitente_obj->nome }}</span>, CPF/CNPJ No <span
                            class="font-weight-bold">{{ $transmitente_obj->cnpj_cpf }}</span>, resindente em <span
                            class="font-weight-bold">{{ $transmitente_obj->endereco }},
                    {{ $transmitente_obj->numero ?? 'SN' }}</span>, Bairro <span
                            class="font-weight-bold">{{ $transmitente_obj->bairro ?? '--' }}</span> ao qual firmo o
                        presente
                        documento.</p>
                </div>

                <div class="mt-3">
                    <p>Medidas:</p>
                    <p>Terreno: <span class="font-weight-bold">{{ $inscricao_obj->areaterreno }}</span> m2</p>
                    <p>Área Construída: <span class="font-weight-bold">{{ $inscricao_obj->areaconstruida }}</span> m2</p>
                </div>

                <div class="mt-5 h7">
                    <p><small>XEROX</small></p>
                    <p> <small> 1 - RG/CPF ou CNPJ;</small></p>
                    <p> <small> 2 - Talão de IPTU Atual;</small></p>
                    <p> <small> 3 - Comprovante de Residência (Água ou Luz);</small></p>
                    <p class="h10"> <small> 4 - Contrato de compra e venda / Escritura Pública.</small></p>

                    <p class="mt2 text-right h6"> <small>{{ session()->get('instituicao')->nome }}, em {{ $dataHoje }}</small></p>

                    <div class="mt-5" align="center">

                        <hr class="w-50 font-weight-bold border-dark">
                        <p> <small> CPF.: {{ $adquirente_obj->cnpj_cpf }} </small></p>
                        <p> <small> {{ $adquirente_obj->nome }} </small></p>

                    </div>


                </div>

            </div>
        </div>
    @else
        {{-- MENSAGEM CASO O REGISTRO NÃO SEJA ENCONTRADO --}}
        @if (session()->has('message'))
            <div class='col-sm-12 col-md-6 offset-md-3'>
                <div class="alert alert-danger text-center" role="alert">
                    <span> {{ session('message') }} </span>
                </div>
            </div>
        @endif
    @endif

    {{--        <div class="card mt-1">--}}
    {{--            <div class="card-header">--}}
    {{--                <b>Débitos</b>--}}
    {{--            </div>--}}
    {{--            <div class="card-body">--}}
    {{--                <table class="table">--}}
    {{--                    <thead>--}}
    {{--                    <tr>--}}
    {{--                        <th scope="col">Descrição</th>--}}
    {{--                        <th scope="col">Vencimento</th>--}}
    {{--                        <th scope="col">Valor</th>--}}
    {{--                        <th scope="col">Boleto</th>--}}
    {{--                    </tr>--}}
    {{--                    </thead>--}}
    {{--                    <tbody>--}}
    {{--                    @if(!empty($financeiros))--}}
    {{--                        @foreach($financeiros as $financeiro)--}}
    {{--                            <tr>--}}
    {{--                                <td>{{ $financeiro->descricao }}</td>--}}
    {{--                                <td>{{ date('d/m/yy', strtotime($financeiro->vencimento)) }}</td>--}}
    {{--                                <td>{{ 'R$ '.number_format($financeiro->valor, 2, ',', '.')  }}</td>--}}
    {{--                                <td><a href="{{ route('boleto', ['id' => $financeiro->idfinanceiro])}}" target=“_blank”><u>Imprimir</u></a></td>--}}
    {{--                            </tr>--}}
    {{--                        @endforeach--}}
    {{--                    @endif--}}
    {{--                    </tbody>--}}
    {{--                </table>--}}
    {{--            </div>--}}
    {{--        </div>--}}

    {{--        --}}{{-- @if(sizeof($financeiros)>0)--}}
    {{--                        <div class="table-responsive">--}}
    {{--                            <table class="table table-hover thead-dark">--}}
    {{--                                <thead class="text-dark">--}}
    {{--                                    <tr>--}}
    {{--                                        <th class="text-center">FINANCEIRO</th>--}}
    {{--                                        <th class="text-center">Empresa</th>--}}
    {{--                                        <th class="text-center">Data</th>--}}
    {{--                                        <th class="text-center">Documento</th>--}}
    {{--                                        <th class="text-center">Valor</th>--}}
    {{--                                        <th class="text-center">Descrição</th>--}}
    {{--                                        <th class="text-center">Código Barras</th>--}}
    {{--                                        <th class="text-center">Boleto</th>--}}
    {{--                                    </tr>--}}
    {{--                                </thead>--}}
    {{--                                <tbody>--}}
    {{--                                    @foreach($financeiros as $financeiro)--}}
    {{--                                    <tr>--}}
    {{--                                        <td class="text-center">{{ $financeiro->id ?? '--' }}</td>--}}
    {{--        <td class="text-center">{{ $financeiro->empresa ?? '--' }}</td>--}}
    {{--        <td class="text-center">{{ $financeiro->data ?? '--' }}</td>--}}
    {{--        <td class="text-center">{{ $financeiro->documento ?? '--' }}</td>--}}
    {{--        <td class="text-center">--}}
    {{--            {{ 'R$ '.number_format($financeiro->valor, 2, ',', '.') ?? '--' }}</td>--}}
    {{--        <td class="text-center">{{ $financeiro->descricao ?? '--' }}</td>--}}
    {{--        <td class="text-center">{{ $financeiro->codigobarra ?? '--' }}</td>--}}
    {{--        <td class="text-center"><button type="button" wire:click="boleto">boleto</button></td>--}}
    {{--        <td class="text-center"><a href="{{ route('boleto', ['id' => $financeiro->id])}}" target=“_blank”>BOLETO</a>--}}
    {{--        </td>--}}
    {{--        </tr>--}}
    {{--        @endforeach--}}
    {{--        </tbody>--}}
    {{--        </table>--}}
    {{--    </div>--}}
    {{--    @endif--}}
    {{--    @endif--}}

</div>

<script>
    $("#itbi").addClass("active");

</script>
