    <div class="card mb-5">
        <div class="card-header">
            <b>EMISSÃO DE BOLETO DE IPTU</b>
        </div>
        <div class="card-body mb-5">
            <div class="col-sm-12 col-md-4 offset-md-4">
                <form wire:submit.prevent="find">
                    {{-- <div class="form-group"><label for="exercicio" class=" form-control-label">Exercício:</label><select
                            name="exercicio" id="exercicio" class="form-control">
                            <option>2020</option>
                            <option>2019</option>
                            <option>2018</option>
                            <option>2017</option>
                            <option>2016</option>
                        </select>
                    </div> --}}
                    <div class="form-group">
                        <label for="inscricao">Inscrição do Imóvel</label>
                        <input wire:model.lazy="inscricao" class="form-control mr-sm-2 m-auto" aria-label="Pesquisar"
                            id="inscricao" type="search" placeholder="Digite a inscrição do imóvel..." />
                    </div>
                    {{-- <a wire:click="find" class="btn btn-primary">PESQUISAR</a> --}}
                    <button type="button" wire:click="find" class="btn btn-primary btn-block">PESQUISAR</button>
                </form>
            </div>

            <div class="m-3">
                <div wire:loading class='col-sm-12 col-md-6 offset-md-3'>
                    <div class="alert alert-info text-center" role="alert">
                        CARREGANDO...
                    </div>
                </div>
            </div>

            {{-- MENSAGEM CASO O IMÓVEL NÃO SEJA ENCONTRADO --}}
            @if (session()->has('message'))
            <div class='col-sm-12 col-md-6 offset-md-3'>
                <div class="alert alert-danger text-center" role="alert">
                    <span> {{ session('message') }} </span>
                </div>
            </div>
            @endif
        </div>

        @if(!empty($imovel))

        <div class="card mt-1">
            <div class="card-header">
                <b>Dados do Imóvel</b>
            </div>
            <div class="card-body">
                <p><b>Inscrição:</b> {{ $imovel->inscricao ?? '--' }}</p>
                <p><b>Cidade:</b> {{ $imovel->cidade ?? '--' }}</p>
                <p><b>UF:</b> {{ $imovel->uf ?? '--' }}</p>
                <p><b>Bairro:</b> {{ $imovel->bairro ?? '--' }}</p>
                <p><b>Endereço:</b> {{ $imovel->endereco ?? '--' }}</p>
            </div>
        </div>

        
            <div class="card mt-1">
                <div class="card-header">
                    <b>Débitos</b>
                </div>
                <div class="card-body">
                    <table class="table">
                        <thead>
                          <tr>
                            <th scope="col">Descrição</th>
                            <th scope="col">Vencimento</th>
                            <th scope="col">Valor</th>
                            <th scope="col">Boleto</th>
                          </tr>
                        </thead>
                        <tbody>
                            @if(!empty($financeiros))
                                @foreach($financeiros as $financeiro)
                                    <tr>
                                        <td>{{ $financeiro->descricao }}</td>
                                        <td>{{ date('d/m/yy', strtotime($financeiro->vencimento)) }}</td>
                                        <td>{{ 'R$ '.number_format($financeiro->valor, 2, ',', '.')  }}</td>
                                        <td><a href="{{ route('boleto', ['id' => $financeiro->idfinanceiro])}}" target=“_blank”><u>Imprimir</u></a></td>
                                    </tr>
                                @endforeach
                            @endif    
                        </tbody>
                      </table>                    
                </div>
            </div>

        {{-- @if(sizeof($financeiros)>0)
                        <div class="table-responsive">
                            <table class="table table-hover thead-dark">
                                <thead class="text-dark">
                                    <tr>
                                        <th class="text-center">FINANCEIRO</th>
                                        <th class="text-center">Empresa</th>
                                        <th class="text-center">Data</th>
                                        <th class="text-center">Documento</th>
                                        <th class="text-center">Valor</th>
                                        <th class="text-center">Descrição</th>
                                        <th class="text-center">Código Barras</th>
                                        <th class="text-center">Boleto</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($financeiros as $financeiro)
                                    <tr>
                                        <td class="text-center">{{ $financeiro->id ?? '--' }}</td>
        <td class="text-center">{{ $financeiro->empresa ?? '--' }}</td>
        <td class="text-center">{{ $financeiro->data ?? '--' }}</td>
        <td class="text-center">{{ $financeiro->documento ?? '--' }}</td>
        <td class="text-center">
            {{ 'R$ '.number_format($financeiro->valor, 2, ',', '.') ?? '--' }}</td>
        <td class="text-center">{{ $financeiro->descricao ?? '--' }}</td>
        <td class="text-center">{{ $financeiro->codigobarra ?? '--' }}</td>
        <td class="text-center"><button type="button" wire:click="boleto">boleto</button></td>
        <td class="text-center"><a href="{{ route('boleto', ['id' => $financeiro->id])}}" target=“_blank”>BOLETO</a>
        </td>
        </tr>
        @endforeach
        </tbody>
        </table>
    </div>
    @endif --}}
    @endif

    </div>

    <script>
        $("#iptu").addClass("active");

    </script>
