<div class="card mb-5">
    <div class="card-header">
        <b>VALIDAR ALVARÁ DE FUNCIONAMENTO</b>
    </div>
    <div class="card-body mb-5">
        <div class="col-sm-12 col-md-4 offset-md-4">
            <form wire:submit.prevent="find">
                <div class="form-group">
                    <label for="numero">Nº do Alvará</label>
                    <input wire:model.lazy="numero"
                           wire.keydown.enter="submit"
                           class="form-control mr-sm-2 m-auto" aria-label="Pesquisar"
                           id="numero" type="search" placeholder="Digite o número do Alvará de Funcionamento..."/>
                    @error('numero') <p><span class="text-danger"> {{ $message }} </span></p> @enderror
                </div>

                <div class="form-group">
                    <label for="validacao">Código da Verificação do Alvará de Funcionamento</label>
                    <input wire:model.lazy="validacao"
                           wire.keydown.enter="submit"
                           class="form-control mr-sm-2 m-auto" aria-label="Pesquisar"
                           id="validacao" type="search" placeholder="Digite o Código da Verificação..."/>
                    @error('validacao') <p><span class="text-danger"> {{ $message }} </span></p> @enderror
                </div>

                <button type="button" wire:click="find" class="btn btn-primary btn-block">PESQUISAR</button>
            </form>
        </div>

        <div class="m-3">
            <div wire:loading class='col-sm-12 col-md-6 offset-md-3'>
                <div class="alert alert-info text-center" role="alert">
                    CARREGANDO...
                </div>
            </div>
        </div>
    </div>

    @if(!empty($alvara))
        <div class="card">
            <div class="card-header font-weight-bold" style="color:#4cd137">
                <i class="fa fa-check-circle" ></i>
                <h5 style="display: inline-block;">ALVARÁ DE FUNCIONAMENTO VERIFICADO</h5>
            </div>
            <div class="card-body">
                <div class="justify">
                    <p><b>DADOS DO ALVARÁ DE FUNCIONAMENTO</b></p>
                    <br>
                    <p><span class="font-weight-bold">Número: </span> {{ $alvara->numero }} </p>
                    <p><span class="font-weight-bold">Empresa: </span> {{ $alvara->empresa }} </p>
                    <p><span class="font-weight-bold">Código de Verificação: </span> {{ $alvara->validacao }} </p>
                </div>
            </div>
        </div>
    @else
        {{-- MENSAGEM CASO O REGISTRO NÃO SEJA ENCONTRADO --}}
        @if (session()->has('message'))
            <div class='col-sm-12 col-md-6 offset-md-3 mt-3'>
                <div class="alert alert-danger text-center" role="alert">
                    <i class="fa fa-times-circle" ></i>
                    <h5 style="display: inline-block;">ALVARÁ DE FUNCIONAMENTO INVÁLIDO</h5>
                </div>
            </div>
        @endif
    @endif

</div>

<script>
    $("#alvara-funcionamento").addClass("active");
</script>
