<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateImoveisTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('imoveis', function (Blueprint $table) {
            $table->id();
            $table->string('inscricao')->nullable();
            $table->integer('codigoimoveis')->nullable();
            $table->string('distrito')->nullable();
            $table->string('setor')->nullable();
            $table->string('quadra')->nullable();
            $table->string('lote')->nullable();
            $table->string('unidade')->nullable();
            $table->string('cnpj_cpf')->nullable();
            $table->string('cidade')->nullable();
            $table->string('uf')->nullable();
            $table->string('bairro')->nullable();
            $table->double('areaterreno')->nullable();
            $table->double('areaconstruida')->nullable();
            $table->double('aliquotaiptu')->nullable();
            $table->string('endereco')->nullable();
            $table->double('valoriptu')->nullable();
            $table->double('valorvenal')->nullable();
            $table->double('taxalixo')->nullable();
            $table->string('empresa')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('imoveis');
    }
}
