<?php

namespace Database\Factories;

use App\Models\Instituicao;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

class InstituicaoFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Instituicao::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'nome' => $this->faker->company,
            'cnpj' => $this->faker->unique()->numberBetween(11111111111, 99999999999),
            'password' => $this->faker->unique()->numberBetween(11111111111, 99999999999),
            'codigo_barras' => $this->faker->unique()->numberBetween(1111111,9999999),
            'admin' => $this->faker->unique()->numberBetween(1111111,9999999)
        ];
    }
}
