<?php

namespace Database\Factories;

use App\Models\Imovel;
use App\Models\Instituicao;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

class ImovelFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Imovel::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'codigoimoveis' => $this->faker->randomNumber(9),
            'empresa' => $this->faker->company,
            'inscricao' => $this->faker->randomNumber(9),
            'cnpj_cpf' => Instituicao::inRandomOrder()->first()->cnpj, //CODIGO DA INSTITUICAO
            'endereco' => $this->faker->streetName,
            'distrito' => $this->faker->city,
            'setor' => $this->faker->title,
            'quadra' => $this->faker->secondaryAddress,
            'lote' => $this->faker->randomNumber(2),
            'unidade' => $this->faker->companySuffix,
            'cidade' => $this->faker->city,
            'uf' => $this->faker->state,
            'bairro' => $this->faker->secondaryAddress,
            'areaterreno' => $this->faker->randomNumber(2),
            'areaconstruida' => $this->faker->randomNumber(2),
            'valorvenal' => $this->faker->randomNumber(3),
            'aliquotaiptu' => $this->faker->randomNumber(3),
            'valoriptu' => $this->faker->randomNumber(3),
            'taxalixo' => $this->faker->randomNumber(3)
        ];
    }
}
