<?php

namespace Database\Factories;

use App\Models\Financeiro;
use App\Models\Instituicao;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

class FinanceiroFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Financeiro::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'idfinanceiro' => $this->faker->unique()->numberBetween(1,999),
            'empresa' => Instituicao::inRandomOrder()->first()->nome,
            'cnpj_cpf' => Instituicao::inRandomOrder()->first()->cnpj,
            'data' => $this->faker->date('Y-m-d'),
            'vencimento' => $this->faker->date('Y-m-d'),
            'documento' => $this->faker->randomNumber(5),
            'descricao' => $this->faker->sentence(1),
            'valor' => $this->faker->randomNumber(2),
            'situacao' => $this->faker->numberBetween(0,1),
            'exercicio' => $this->faker->numberBetween(0,1),
            'codigobarra' => $this->faker->randomNumber(9),
            'nossonumero' => $this->faker->randomNumber(9),
            'contareceita' => $this->faker->randomNumber(4),
            'cb_codigobanco' => $this->faker->randomNumber(2),
            'cb_agencia' => $this->faker->randomNumber(2),
            'cb_dgagencia' => $this->faker->randomNumber(2),
            'cb_contabancaria' => $this->faker->randomNumber(2),
            'cb_dgcontabancaria' => $this->faker->randomNumber(2),
            'cb_descricaocontabancaria' => $this->faker->sentence(7),
            'valor_pago' => $this->faker->randomNumber(2),
            'juros' => $this->faker->randomNumber(2),
            'multa' => $this->faker->randomNumber(2),
            'desconto' => $this->faker->randomNumber(2),
            'avulso' => $this->faker->randomNumber(2),
            'tipotributo' => $this->faker->numberBetween(1,9),
            'codigotributo' => $this->faker->randomNumber(4),
            'historico' => $this->faker->randomNumber(3),
            'numeroparcela' => $this->faker->unique()->randomNumber(2),
            'dtpagamento' => $this->faker->date('Y-m-d')
        ];
    }
}
