<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Instituicao extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'nome',
        'cnpj',
        'codigo_barras',
        'admin',
        'link_nfe'
    ];

    protected $hidden = [
        'password'
    ];

    protected $table = 'instituicoes';
    protected $primaryKey = 'id';

    protected $nome = 'nome';
    protected $cnpj = 'cnpj';
    protected $password = 'password';

    public function imoveis()
    {
        return $this->hasMany(Imovel::class, 'cnpj_cpf', 'cnpj');
    }

    public function financeiros()
    {
        return $this->hasMany(Financeiro::class, 'cnpj_cpf', 'cnpj');
    }

    public function fornecedores()
    {
        return $this->hasMany(Fornecedor::class, 'cnpj_cpf', 'cnpj');
    }
}
