<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Fornecedor extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'nome',
        'cnpj_cpf',
        'tipopessoa',
        'endereco',
        'numero',
        'complemento',
        'bairro',
        'cidade',
        'uf',
        'fone',
        'inscestadual',
        'inscmunicipal',
        'empresa',
        'cep',
        'mei',
        'email',
        'devedor'
    ];

    protected $table = 'fornecedores';

    protected $primaryKey = 'id';

    protected $nome = 'nome';
    protected $cnpj_cpf = 'cnpj_cpf';
    protected $tipopessoa = 'tipopessoa';
    protected $endereco = 'endereco';
    protected $numero = 'numero';
    protected $complemento = 'complemento';
    protected $bairro = 'bairro';
    protected $cidade = 'cidade';
    protected $uf = 'uf';
    protected $fone = 'fone';
    protected $inscestadual = 'inscestadual';
    protected $inscmunicipal = 'inscmunicipal';
    protected $empresa = 'empresa';
    protected $cep = 'cep';
    protected $mei = 'mei';
    protected $email = 'email';
    protected $devedor = 'devedor';

    public function instituicao()
    {
        return $this->belongsTo(Instituicao::class, 'cpf_cnpj','cnpj');
    }
}
