<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Estabelecimento extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['nome'];

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'estabelecimentos';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'id';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $nome = 'nome';

    public function usuarios()
    {
        return $this->belongsToMany(User::class, 'estabelecimento_user', 'estabelecimento_id', 'user_id');
    }

    public function gestor()
    {
        return $this->belongsTo(User::class);
    }

    public function creditos()
    {
        return $this->hasMany(Credito::class);
    }
}
