<?php

namespace App\Http\Livewire\Validacao;

use App\Models\CertidaoNegativa;
use Livewire\Component;

class Validacao extends Component
{
    public $pesquisa = '';
    public $certidaoNegativa = null;

    public function render()
    {
        return view('livewire.validacao.validacao');
    }

    public function find()
    {
        $this->certidaoNegativa = CertidaoNegativa::whereCodigoControle($this->pesquisa)->first();

        if(!$this->certidaoNegativa){
            session()->flash('message', 'CERTIDÃO NEGATIVA NÃO ENCONTRADA.');
            return false;
        }
        return true;
    }
}
