<?php

namespace App\Http\Livewire\NotaFiscal;

use App\Models\Financeiro;
use App\Models\Imovel;
use App\Models\Nfse;
use Livewire\Component;

class Validar extends Component
{
    public $numero_nsfe, $codigo_verificacao;

    public $nfse;

    public function rules()
    {
        return [
            'numero_nsfe' => 'required|int',
            'codigo_verificacao' => 'required|numeric',
        ];
    }

    public function find()
    {
        $this->validate();

        $instituicao_cnpj = session()->get('instituicao')->cnpj;

        $this->nfse = Nfse::where('na_numero', $this->numero_nsfe)
                    ->where('na_Validacao', $this->codigo_verificacao)
                    ->where('na_empresa', $instituicao_cnpj)->first();

        if(!($this->nfse)){
            session()->flash('message', 'NOTA FISCAL NÃO ENCONTRADA');
            return false;
        }

    }

    public function render()
    {
        return view('livewire.nota-fiscal.validar');
    }
}
