<?php

namespace App\Http\Livewire\Itbi;

use App\Models\Fornecedor;
use App\Models\Imovel;
use Livewire\Component;

class Itbi extends Component
{
    public $numero_guia, $adquirente, $transmitente, $inscricao;

    public $adquirente_obj, $transmitente_obj, $inscricao_obj;

    public $dataHoje;

    public function rules()
    {
        return [
            'numero_guia'   => 'required|int',
            'adquirente'    => 'required|int',
            'transmitente'  => 'required|int',
            'inscricao'     => 'required|int',
        ];
    }

    public function find()
    {
        $this->validate();

        $this->adquirente_obj = Fornecedor::where('cnpj_cpf', $this->adquirente)
                                ->first();

        if(!$this->adquirente_obj){
            session()->flash('message', 'ADQUIRENTE NÃO ENCONTRADO');
            return false;
        }

        $this->transmitente_obj = Fornecedor::where('cnpj_cpf', $this->transmitente)
                                    ->first();

        if(!$this->transmitente_obj){
            session()->flash('message', 'TRANSMITENTE NÃO ENCONTRADO');
            return false;
        }

        $this->inscricao_obj = Imovel::where('inscricao', $this->inscricao)
                                    ->where('cnpj_cpf', $this->adquirente)
                                    ->first();

        if(!$this->inscricao_obj){
            session()->flash('message', 'IMÓVEL NÃO ENCONTRADO');
            return false;
        }

        $this->formatarData();

        return true;
    }

    public function formatarData()
    {
        setlocale(LC_TIME, 'pt_BR', 'pt_BR.utf-8', 'pt_BR.utf-8', 'portuguese');
        date_default_timezone_set('America/Sao_Paulo');

        $this->dataHoje = strftime('%A, %d de %B de %Y', strtotime('today'));
    }

    public function render()
    {
        return view('livewire.itbi.itbi');
    }
}
