<?php

namespace App\Http\Livewire\Certidao;

use App\Models\Fornecedor;
use Livewire\Component;
use PDF;
use App;

class Certidao extends Component
{

    public $cnpj_cpf = '';
    public $fornecedor;

    public function render()
    {
        return view('livewire.certidao.certidao');
    }

    public function find()
    {
        $instituicao_cnpj = session()->get('instituicao')->cnpj;

        $this->fornecedor = Fornecedor::where('cnpj_cpf', '=', $this->cnpj_cpf)
            ->where('empresa', '=', $instituicao_cnpj)
            ->first();

        if(!$this->fornecedor){
            session()->flash('message', 'FORNECEDOR NÃO ENCONTRADO');
        }
    }

    public function emitirCertidao(){
        $pdf = PDF::loadView('livewire.instituicao.show');
        return $pdf->download('pdf_file.pdf');
        // return $pdf->stream();
    }

}
