<?php

namespace App\Http\Livewire\Boleto;

use App\Models\Financeiro;
use App\Models\Instituicao;
use DateTime;
use Dompdf\Dompdf;
use Livewire\Component;
use OpenBoleto\Agente;
use OpenBoleto\Banco\BancoDoBrasil;
use PDF;

class GerarBoleto extends Component
{
    public $financeiro;
    public $boleto;
    private $instituicao, $sacado, $cedente;

    public function render() 
    {
        return view('livewire.boleto.gerar-boleto');
    }

    public function mount($id){
        $cnpj_instituicao = session()->get('instituicao')->cnpj;

        $this->financeiro = Financeiro::where('idfinanceiro', '=', $id)
        ->where('empresa', '=', $cnpj_instituicao)
        ->first();

        $this->instituicao = Instituicao::where('cnpj','=',$cnpj_instituicao)->first();

        $this->cedente = new Agente($this->instituicao->nome, $this->instituicao->cnpj, 'ENDERECO -----', 'CEP ----', 'Cidade ----', 'UF');
        $this->sacado = new Agente('', '', '', '', '', '');

        switch ($this->financeiro->cb_codigobanco) {
            case '001':
                $this->banco_do_brasil();
                break;
            
            default:
                ECHO 'BANCO NÃO CADASTRADO';
                break;
        }
    }

    private function banco_do_brasil(){

        $b = new BancoDoBrasil(array(
            // Parâmetros obrigatórios
            'dataVencimento' => new DateTime($this->financeiro->vencimento),
            'valor' => $this->financeiro->valor,
            'sequencial' => $this->financeiro->idfinanceiro, // Para gerar o nosso número
            'sacado' => $this->sacado,
            'cedente' => $this->cedente,
            'agencia' => 1111, // Até 4 dígitos
            'carteira' => 18,
            'conta' => 11111111, // Até 8 dígitos
            'convenio' => 1234, // 4, 6 ou 7 dígitos
        ));

        // $b->getLinhaDigitavel() = '5555555555555';

        echo $b->getOutput();

        echo 'poasjkmasdpjomdiajsdojmasiodj';
    }

}
