<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Fornecedor;
use App\Models\CertidaoNegativa;
use PDF;

class PDFController extends Controller
{
    public function index(Request $request)
    {
        $cnpj_cpf = $request->cnpj_cpf;
        $instituicao_cnpj = session()->get('instituicao')->cnpj;
        $instituicao_nome = session()->get('instituicao')->nome;

        $fornecedor = Fornecedor::where('cnpj_cpf','=',$cnpj_cpf)
        ->where('empresa','=',$instituicao_cnpj)->first();

        $autenticacao = round(microtime(true) * 1000);

        $data = [
            'autenticacao' => $autenticacao,
            'nome' => $fornecedor->nome,
            'cnpj_cpf' => $fornecedor->cnpj_cpf,
            'endereco' => $fornecedor->endereco,
            'brasao' => $instituicao_cnpj,
            'instituicao' => $instituicao_nome,
        ];
           
        $pdf = PDF::loadView('certidao-pdf', $data);
        
        $this->gravarCertidao($fornecedor, $autenticacao);

        return $pdf->stream();
    }

    private function gravarCertidao($fornecedor, $autenticacao){
        CertidaoNegativa::create([
            'nome_contribuinte' => $fornecedor->nome, //fornecedor
            'cnpj_cpf' => $fornecedor->cnpj_cpf, // fornecedor
            'empresa' => $fornecedor->empresa, // sessao
            'codigo_controle' => $autenticacao,
        ]);
    }

    public function transferencia(Request $request)
    {
        // $cnpj_cpf = $request->cnpj_cpf;
        $instituicao_cnpj = session()->get('instituicao')->cnpj;
        $instituicao_nome = session()->get('instituicao')->nome;

        // $fornecedor = Fornecedor::where('cnpj_cpf','=',$cnpj_cpf)
        // ->where('empresa','=',$instituicao_cnpj)->first();

        // $autenticacao = round(microtime(true) * 1000);

        $data = [
        //     'autenticacao' => $autenticacao,
        //     'nome' => $fornecedor->nome,
        //     'cnpj_cpf' => $fornecedor->cnpj_cpf,
        //     'endereco' => $fornecedor->endereco,
            'brasao' => $instituicao_cnpj,
            'instituicao' => $instituicao_nome,
        ];

        $pdf = PDF::loadView('pdf.transferencia-pdf', $data);
        
        return $pdf->stream();
    }

    public function itbi(Request $request)
    {
        // $cnpj_cpf = $request->cnpj_cpf;
        $instituicao_cnpj = session()->get('instituicao')->cnpj;
        $instituicao_nome = session()->get('instituicao')->nome;

        // $fornecedor = Fornecedor::where('cnpj_cpf','=',$cnpj_cpf)
        // ->where('empresa','=',$instituicao_cnpj)->first();

        // $autenticacao = round(microtime(true) * 1000);

        $data = [
        //     'autenticacao' => $autenticacao,
        //     'nome' => $fornecedor->nome,
        //     'cnpj_cpf' => $fornecedor->cnpj_cpf,
        //     'endereco' => $fornecedor->endereco,
            'brasao' => $instituicao_cnpj,
            'instituicao' => $instituicao_nome,
        ];

        $pdf = PDF::loadView('pdf.itbi-pdf', $data);
        
        return $pdf->stream();
    }
}
