<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use App\Models\Nfse;
use App\Http\Controllers\Api\BaseController;

class NfseController extends BaseController
{
    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        Log::info('ENVIOU NFSE.-----------------------------------------------------------');
        Log::info($request);

        $retorno = [];
        $erro = [];

        foreach ($request->post()['nfse'] as $key => $nf) {
            try {
                Nfse::updateOrCreate(
                    [
                        'na_numero' => $nf['na_numero']
                    ],
                    [
                        'na_numero' => $nf['na_numero'],
                        'na_dataNota' => $nf['na_dataNota'],
                        'na_prestador' => $nf['na_prestador'],
                        'na_nomeprestador' => $nf['na_nomeprestador'],
                        'na_valor' => $nf['na_valor'],
                        'na_mes' => $nf['na_mes'],
                        'na_exercicio' => $nf['na_exercicio'],
                        'na_situacao' => $nf['na_situacao'],
                        'na_Validacao' => $nf['na_Validacao'],
                        'na_empresa' => $nf['na_empresa'],
                    ]
                );

                $retorno[] = 'Nota Fiscal atualizada com sucesso (' . $nf['na_numero'] . ')';

            } catch (\Exception $exception) {
                $erro[$nf['na_numero']] = $exception->getMessage();
            }
        }

        return $this->sendResponse($retorno, 'Resposta', $erro);
    }
}
