<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Itbi;
use Illuminate\Http\Request;
use App\Http\Controllers\Api\BaseController;
use Illuminate\Support\Facades\Log;

class ItbiController extends BaseController
{

    function array_replace_key(&$arr, $old, $new, $overwrite = true): bool {
        if (isset($arr[$new]) and !$overwrite) {
            return false;
        }

        $arr[$new] = $arr[$old];
        unset($arr[$old]);

        return true;
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        Log::info('ENVIOU ITBI. --------------------------------------------------------');
        Log::info($request);

        $retorno = [];
        $erro = [];

////        TRANSFORMA TODOS OS ÍNDICES PARA MINÚSCULO
//        $newItbi = array();
//        foreach ($request->post()['itbi'] as $key => $itbi) {
//            foreach ($itbi as $keyItbi => $value){
//                $newItbi[$key][strtolower($keyItbi)] = $value;
//            }
//        }

        foreach ($request->post()['itbi'] as $itbi) {
            try {
                Itbi::updateOrCreate(
                    [
                        'imovel' => $itbi['imovel']
                    ],
                    [
                        'imovel' => $itbi['imovel'],
                        'transmitente' => $itbi['transmitente'],
                        'comprador' => $itbi['comprador'],
                        'dataLancamento' => $itbi['dataLancamento'],
                        'dataTransacao' => $itbi['dataTransacao'],
                        'valorVenal' => $itbi['valorVenal'],
                        'valorInstrumento' => $itbi['valorInstrumento'],
                        'parteFinanciada' => $itbi['parteFinanciada'],
                        'parteNaoFinanciada' => $itbi['parteNaoFinanciada'],
                        'aliquota' => $itbi['aliquota'],
                        'naturezaTransacao' => $itbi['naturezaTransacao'],
                        'observacoes' => $itbi['observacoes'],
                        'exercicio' => $itbi['exercicio'],
                        'empresa' => $itbi['empresa'],
                        'usuario' => $itbi['usuario'],
                        'situacao' => $itbi['situacao'],

                        'inscricao_imovel' => isset($itbi['inscricao_imovel']) ? $itbi['inscricao_imovel'] : $itbi['inscricao_Imovel'],
                        'inscricao_endereco' => $itbi['inscricao_endereco'],
                        'inscricao_numero' => $itbi['inscricao_numero'],
                        'inscricao_bairro' => $itbi['inscricao_bairro'],
                        'inscricao_cidade' => $itbi['inscricao_cidade'],
                        'inscricao_uf' => $itbi['inscricao_uf'],

                        'transmitente_endereco' => $itbi['transmitente_endereco'],
                        'transmitente_numero' => $itbi['transmitente_numero'],
                        'transmitente_bairro' => $itbi['transmitente_bairro'],
                        'transmitente_cidade' => $itbi['transmitente_cidade'],
                        'transmitente_uf' => $itbi['transmitente_uf'],

                        'comprador_endereco' => $itbi['comprador_endereco'],
                        'comprador_numero' => $itbi['comprador_numero'],
                        'comprador_bairro' => $itbi['comprador_bairro'],
                        'comprador_cidade' => $itbi['comprador_cidade'],
                        'comprador_uf' => $itbi['comprador_uf']
                    ]
                );

                $retorno[] = 'ITBI atualizado com sucesso (' . $itbi['imovel'] . ')';

            } catch (\Exception $exception) {
                $erro[$itbi['imovel']] = $exception->getMessage();
            }
        }

        return $this->sendResponse($retorno, 'Resposta', $erro);
    }
}
