<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Api\BaseController as BaseController;
use App\Models\Imovel;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class ImovelController extends BaseController
{
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        Log::info('ENVIOU IMÓVEIS.');

        $retorno = [];
        $erro = [];

        foreach ($request->post()['imoveis'] as $imovel) {
            try {
                Imovel::updateOrCreate(
                    [
                        'inscricao' => $imovel['inscricao'],
                        'empresa' => $imovel['empresa']
                    ],
                    [
                        'codigoimoveis' => $imovel['codigoimoveis'],
                        'empresa' => $imovel['empresa'],
                        'cnpj_cpf' => $imovel['cnpj_cpf'],
                        'inscricao' => $imovel['inscricao'],
                        'endereco' => $imovel['endereco'],
                        'distrito' => $imovel['distrito'],
                        'setor' => $imovel['setor'],
                        'quadra' => $imovel['quadra'],
                        'lote' => $imovel['lote'],
                        'unidade' => $imovel['unidade'],
                        'cidade' => $imovel['cidade'],
                        'uf' => $imovel['uf'],
                        'bairro' => $imovel['bairro'],
                        'areaterreno' => $imovel['areaterreno'],
                        'areaconstruida' => $imovel['areaconstruida'],
                        'valorvenal' => $imovel['valorvenal'],
                        'aliquotaiptu' => $imovel['aliquotaiptu'],
                        'valoriptu' => $imovel['valoriptu'],
                        'taxalixo' => $imovel['taxalixo']
                    ]
                );

                $retorno[] = 'Imóvel atualizado com sucesso ('.$imovel['codigoimoveis'].')';

            }catch (\Exception $exception){
                $erro[$imovel['codigoimoveis']] = $exception->getMessage();
            }
        }

        return $this->sendResponse($retorno, 'Resposta', $erro);
    }


}
