<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Api\BaseController as BaseController;
use App\Models\Fornecedor;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class FornecedorController extends BaseController
{
    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        Log::info('ENVIOU FORNECEDORES.');

        $retorno = [];
        $erro = [];

        foreach ($request->post()['fornecedor'] as $fornecedor) {
            try {
                Fornecedor::updateOrCreate(
                    [
                        'cnpj_cpf' => $fornecedor['cnpj_cpf'],
                        'empresa' => $fornecedor['empresa']
                    ],
                    [
                        'nome' => $fornecedor['nome'],
                        'cnpj_cpf' => $fornecedor['cnpj_cpf'],
                        'tipopessoa' => $fornecedor['tipopessoa'],
                        'endereco' => $fornecedor['endereco'],
                        'numero' => $fornecedor['numero'],
                        'complemento' => $fornecedor['complemento'],
                        'bairro' => $fornecedor['bairro'],
                        'cidade' => $fornecedor['cidade'],
                        'uf' => $fornecedor['uf'],
                        'fone' => $fornecedor['fone'],
                        'inscestadual' => $fornecedor['inscestadual'],
                        'inscmunicipal' => $fornecedor['inscmunicipal'],
                        'empresa' => $fornecedor['empresa'],
                        'cep' => $fornecedor['cep'],
                        'mei' => $fornecedor['mei'],
                        'email' => $fornecedor['email'],
                        'devedor' => $fornecedor['devedor'] ?? 0
                    ]
                );

                $retorno[] = 'Fornecedor atualizado com sucesso: ' . $fornecedor['cnpj_cpf'];

            } catch (\Exception $exception) {
                $erro[$fornecedor['cnpj_cpf']] = $exception->getMessage();
            }
        }

        return $this->sendResponse($retorno, 'Resposta', $erro);
    }
}
